```nginx
# /etc/nginx/sites-available/home.conf
server {
    listen 443 ssl http2;
    listen [::]:443 ssl http2;
    server_name home.example.com *.home.example.com;
    include /etc/nginx/snippets/authloc.conf;
    location / {
        include /etc/nginx/snippets/authinc.conf;
        proxy_pass http://10.8.0.2:80;
    }
}

# /etc/nginx/sites-available/auth.conf
server {
    listen [::]:443 ssl http2;
    listen 443 ssl http2;
    server_name auth.example.com;
    include /etc/nginx/snippets/ssl-examplecom.conf;
    location / {
        proxy_pass http://localhost:9091;
        include /etc/nginx/snippets/proxy.conf;
    }
}

# /etc/nginx/snippets/proxy.conf
# global proxy conf
proxy_set_header Host $host;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header X-Forwarded-Proto $scheme;
proxy_set_header X-Forwarded-Host $host:$server_port;
proxy_set_header X-Forwarded-Port $server_port;
proxy_redirect off;
client_body_buffer_size 128k;
client_max_body_size 0;
send_timeout 5m;
proxy_read_timeout 240;
proxy_send_timeout 240;
proxy_connect_timeout 240;
# websocket support
proxy_http_version 1.1;
proxy_set_header Upgrade $http_upgrade;
proxy_set_header Connection $connection_upgrade;

# /etc/nginx/snippets/authproxy.conf
include /etc/nginx/snippets/proxy.conf;
proxy_next_upstream error timeout invalid_header http_500 http_502 http_503;
proxy_set_header X-Forwarded-Host $http_host;
proxy_set_header X-Forwarded-Uri $request_uri;
proxy_set_header X-Forwarded-Ssl on;
proxy_redirect http:// $scheme://;
proxy_cache_bypass $cookie_session;
proxy_no_cache $cookie_session;
proxy_buffers 4 32k;

# /etc/nginx/snippets/authloc.conf
location /auth {
    internal;
    proxy_pass_request_body off;
    proxy_pass http://localhost:9091/api/verify;
    proxy_set_header Content-Length "";
    include /etc/nginx/snippets/authproxy.conf;
}

# /etc/nginx/snippets/authinc.conf
auth_request /auth;
auth_request_set $target_url $scheme://$http_host$request_uri;
auth_request_set $user $upstream_http_remote_user;
auth_request_set $groups $upstream_http_remote_groups;
proxy_set_header Remote-User $user;
proxy_set_header Remote-Groups $groups;
error_page 401 =302 https://auth.example.com/?rd=$target_url;

# /etc/nginx/snippets/ssl.conf
    # OCSP stapling
    ssl_stapling on;
    ssl_stapling_verify on;

    add_header Strict-Transport-Security "max-age=63072000; includeSubDomains; preload" always;

    ssl_protocols TLSv1.2 TLSv1.3;
    ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:DHE-RSA-CHACHA20-POLY1305;
    ssl_prefer_server_ciphers off;

    resolver 1.1.1.1;

    ssl_session_timeout 1d;
    ssl_session_cache shared:MozSSL:10m;  # about 40000 sessions
    ssl_session_tickets off;

    ssl_dhparam /etc/nginx/dhparam.pem;

# /etc/nginx/snippets/ssl-home.conf
    ssl_certificate /etc/letsencrypt/live/home.example.com/fullchain.pem;
    ssl_certificate_key /etc/letsencrypt/live/home.example.com/privkey.pem;
    ssl_trusted_certificate /etc/letsencrypt/live/home.example.com/fullchain.pem;
    include /etc/nginx/snippets/ssl.conf;
```