from util import hook,http,web
from urllib2 import HTTPError

@hook.regex(r'instagram.com/p/(.+?)/')
def ig_regex(match, bot=None):
    """ Returns info for instagram urls """
    token = bot.config.get("api_keys", {}).get("instagram", None)
    try:
        data = http.get_json("https://api.instagram.com/v1/media/shortcode/{}?access_token={}".format(match.group(1), token))["data"]
        return u"{caption[from][full_name]}: \"{caption[text]}\" ({likes[count]} likes)".format(**dict(emoji=u"\u1F5BC" if data["type"] == "image" else u"\u1F4FC", **data))
    except (ValueError, HTTPError, KeyError) as e:
        raise
