#!/usr/bin/env python3
def sec(s):
    m,s = divmod(int(s), 60)
    h,m = divmod(m,60)
    return "%d:%02d:%02d" % (h,m,s)

def convert(data):
    if isinstance(data, bytes):  return data.decode('ascii')
    if isinstance(data, dict):   return dict(map(convert, data.items()))
    if isinstance(data, tuple):  return map(convert, data)
    return data

from hurry.filesize import size
from deluge_client import DelugeRPCClient
client = DelugeRPCClient("127.0.0.1", 58846, "me", "you")
client.connect()
torrents = client.call("core.get_torrents_status", {"state": "Downloading"}, [])
if not torrents:
    print("Nothing going at the moment")
else:
    torrents = convert(torrents)
    for torrent, data in torrents.items():
        data["until"] = sec(data["eta"])
        data["dlrate"] = size(data["download_payload_rate"])
        print("{progress:.0f}% {until} {dlrate}/s: {name}".format(**data))