from plexapi.server import PlexServer
import argparse

DEFAULT_URI = "http://192.168.1.50:32400"

def fmtcols(l):
    maxlen = max(len(i) for i in l)
    if len(l) % 2 != 0:
        l.append(" ")
    split = len(l)/2
    l1 = l[0:split]
    l2 = l[split:]
    o = []
    for key, value in zip(l1,l2):
        o.append(u"{0:<{2}s} {1}".format(key, value, maxlen))
    return u"\n".join(o)

def get_server(uri=DEFAULT_URI):
    return PlexServer(uri)

def lookup_movie(server, movie):
    return server.library.section("Movies").get(movie)

def lookup_episode(server, show, episode):
    return server.library.section("TV Shows").get(show).episode(episode)

def main():
    parser = argparse.ArgumentParser()
    group = parser.add_mutually_exclusive_group()
    group.add_argument("-m", "--movie", help="Specify movie. Must be exact title.")
    group.add_argument("-s", "--show", help="Specify show. Must be exact title.")
    parser.add_argument("-e", "--episode", help="Specify episode. Get list of episodes by specifying show")
    parser.add_argument("-S", "--server", nargs="?", help="Specify server. Defaults to {}".format(DEFAULT_URI), default=DEFAULT_URI)
    args = parser.parse_args()
    server = get_server(args.server)
    if args.movie is not None:
        if args.movie is "":
            print fmtcols([u"{}".format(movie.title) for movie in server.library.section("Movies").all()])
        else:
            print lookup_movie(server, args.movie).getStreamUrl()
    elif args.show is not None:
        if args.show is "":
            print fmtcols([u"{}".format(show.title) for show in server.library.section("TV Shows").all()])
        else:
            if args.episode:
                print lookup_episode(server, args.show, args.episode).getStreamUrl()
            else:
                print fmtcols([u"S{}E{} {}".format(ep.parentIndex.zfill(2), ep.index.zfill(2), ep.title) for ep in server.library.section("TV Shows").get(args.show).episodes()])

if __name__ == "__main__":
    main()