#!/usr/bin/env python3
from subprocess import Popen, PIPE
from flask import Flask, Response
import os.path

app = Flask(__name__)
PREFIX = "/media/storage"
FORMAT = ("mp3", "audio/mpeg")

def ffmpeg_generator(fn):
    process = Popen(["ffmpeg", "-hide_banner", "-loglevel", "panic", "-i", fn, "-f", FORMAT[0], "-"], stdout=PIPE)
    while True:
        data = process.stdout.read(1024)
        if not data:
            break
        yield data

@app.route("/")
@app.route("/favicon.ico")
def nothing():
    return "", 404

@app.route("/<path:path>")
def play(path):
    path = os.path.normpath("/" + path).lstrip("/")
    return Response(ffmpeg_generator(os.path.join(PREFIX, path)), mimetype=FORMAT[1])

if __name__ == "__main__":
    app.run()