#!/usr/bin/env python3
import irc3
import websockets
import asyncio
import json

@irc3.plugin
class DCIRC:
    requires = ["irc3.plugins.command"]

    def __init__(self, bot):
        self.bot = bot
        self.bot.loop.create_task(self.websocket("wss://localhost:5601"))

    async def websocket(self, uri):
        headers = {"Cookie": ""}
        websocket = websockets.client.connect(uri, extra_headers=headers)
        await websocket.send(json.dumps({"path":"session/v0/socket","method":"POST","data":{"authorization":""},"callback_id":1}))
        while True:
            msg = json.loads(await websocket.recv())
            if "event" in msg and msg["event"] == "hub_message":
                n = msg["data"]["from"]["nick"]
                msg["data"]["from"]["nick"] = n[0] + "\u200b" + n[1:]
                self.bot.privmsg(self.bot.config["autojoins"][0],
                    "<{from[nick]}> {text}".format(**msg["data"]))

def main():
    config = dict(nick="", autojoins=[""], host="irc..net", port=6667, includes=["irc3.plugins.core", "irc3.plugins.command", __name__])
    bot = irc3.IrcBot.from_config(config)
    bot.run(forever=True)

if __name__ == "__main__":
    main()
