#!/usr/bin/env python3
import requests
from xml.etree import ElementTree

ROUTER_IP = "192.168.17.1"

def b2B(num_of_bytes):
    if type(num_of_bytes) not in (float, int):
        num_of_bytes = float(num_of_bytes)
    opts, i = "KMGTP", -1
    while num_of_bytes > 1000:
        num_of_bytes = num_of_bytes / 1000
        i += 1
    return "{:.2f}{}B".format(num_of_bytes, opts[i])

def hms(s):
    m,s = divmod(s,60)
    h,m = divmod(m,60)
    d,h = divmod(h,24)
    y,d = divmod(d,365)
    return y,d,h,m,s

i = requests.get("http://{}/html/home.html".format(ROUTER_IP))
d = ElementTree.fromstring(requests.get("http://{}/api/monitoring/traffic-statistics".format(ROUTER_IP), headers={"Cookie": i.headers["Set-Cookie"]}).text)
for e in d:
    if e.tag in ["CurrentConnectTime", "TotalConnectTime"]:
        print("{}: {}".format(e.tag, ":".join(str(x).zfill(2) for x in hms(int(e.text)) if x)))
    if e.tag in ["CurrentUpload", "CurrentDownload", "TotalUpload", "TotalDownload"]:
        print("{}: {}".format(e.tag, b2B(e.text)))
    if e.tag in ["CurrentUploadRate", "CurrentDownloadRate"]:
        print("{}: {}/s".format(e.tag, b2B(float(e.text)*1024)))