"""Welcome to py-textadventure!

This is a library intended to make writing text adventures really simple.

Below is a sample text adventure that mirrors the first few areas of Zork with a couple small changes.

I hope you enjoy using this library!"""

from textadventure import Room, Object, Item
import random


class Mailbox(Object):
    # view text is shown in the 'look' text for a given room
    view = "There is a small mailbox here."
    # Descriptions are shown with 'examine Mailbox'
    description = "I see nothing special about the mailbox."
    # if objects is not None, an object is openable (closed by default) and contains the given items
    objects = [Leaflet]

# Object = fixed part of scene. Item = inventoriable object
class Leaflet(Item):
    description = __doc__

class Welcome_Mat(Item):
    description = "Welcome to py-textadventure!"
    view = "A rubber mat saying \"{}\" lies by the door.".format(self.description)

class Handset(Item):
    description = "The voice on the other end is crackly, but you can make out the words \"Thank you for playing this sample game!\" before it explodes, killing you instantly."
    instant_death = True


# Room bold text is taken from class name (West_of_House >> "West of House"), but can be overridden
class West_of_House(Room):
    description = "This is an open field west of a white house, with a boarded front door."
    objects = [Mailbox, Welcome_Mat]
    north = North_of_House
    south = South_of_House
    west = Forest
    east = False, "The door is locked, and there is evidently no key."

_house_desc = "You are facing the {} side of a white house.  There is no door here, and all the windows are barred."
class North_of_House(Room):
    description = _house_desc.format("north")
    north = Forest
    south = False, "The windows are all barred."
    east = East_of_House
    west = West_of_House

class South_of_House(Room):
    description = _house_desc.format("south")
    north = False, "The windows are all barred"
    south = Forest
    west = West_of_House
    east = East_of_House

class East_of_House(Room):
    # Room bold text, defaults to class name without underscores
    view = "Behind House"
    description = "You are behind the white house. In one corner of the house there is a small window which is slightly ajar."
    north = North_of_House
    south = South_of_House
    west = self.is_window_closed()
    east = Forest
    objects = [Window]
    def is_window_closed(self):
        if self.window_open == True:
            return Game_Over
        return False, "The window is closed."

class Clearing(Room):
    description = "You are in a clearing, with a forest surrounding you on the west and south."
    north = Clearing
    east = Clearing
    west = Forest
    south = Forest

class Forest(Room):
    description = random.choice([
        "This is a forest, with trees in all directions around you.",
        "This is a large forest, with trees obstructing all views except to the east, where a small clearing may be seen through the trees.",
        "This is a dimly lit forest, with large trees all around.  To the east, there appears to be sunlight."
    ])
    north = self.wandering_test(South_of_House)
    south = self.wandering_test(North_of_House)
    west = self.wandering_test(East_of_House)
    east = Clearing

    def wandering_test(self, dest_room):
        if self.player.wandering > 2:
            self.player.wandering = 0
            return dest_room
        self.player.wandering += 1
        return Forest

class Game_Over(Room):
    description = "The inside of the house is an enormous empty white room with a disconnected handset in the centre. You hear buzzing from the handset."
    objects = [Handset]
    north = False, "There's no way out there."
    south = False, "There's no way out there."
    east = East_of_House
    west = False, "There's no way out there."