#!/usr/bin/env python2
from __future__ import print_function
import sys
from glob import glob
from random import shuffle
import os.path

def playdir(directory):
    def get_playlist():
        playlist = glob("{}/*.ogg".format(directory))
        print("Loading playlist with {} items...".format(len(playlist)), file=sys.stderr)
        shuffle(playlist)
        return playlist
    if not os.path.exists("{}.lst".format(directory)):
        with open("{}.lst".format(directory), "w") as f:
            f.write("\n".join(get_playlist()))
    with open("{}.lst".format(directory)) as f:
        pl = [c.strip() for c in f.readlines() if c.strip()]
        if len(pl) < 2:
            pl += get_playlist()
        curfile = pl.pop(0)
        print(curfile)
        print("Playing {}".format(curfile), file=sys.stderr)
    with open("{}.lst".format(directory), "w") as f:
        f.write("\n".join(pl))

def main():
    if len(sys.argv) < 2:
        print("Supply directory", file=sys.stderr)
        return 1
    playdir(sys.argv[1])
    return 0

if __name__ == "__main__":
    sys.exit(main())
