#!/usr/bin/env python3
from flask import *

app = Flask(__name__)

@app.route("/")
def index():
    buckets = "\n".join(f"scoop bucket add {bucket}" for bucket in request.args.get("buckets","").split(",")) if "buckets" in request.args else ""
    packages = "\n".join(f"scoop install {package}" for package in request.args.get("pkgs","").split(",")) if "pkgs" in request.args else ""
    return f"""Set-ExecutionPolicy RemoteSigned -scope CurrentUser
iwr -useb get.scoop.sh | iex
scoop install git
scoop update
{buckets}
{packages}
"""