#!/usr/bin/env python3
from gmusicapi import Musicmanager # pip install gmusicapi
from glob import glob
from argparse import ArgumentParser
from sys import stderr
from urllib.parse import quote_plus

m = Musicmanager()
if not m.login():
    m.perform_oauth()
    m.login()

def upload(path):
    uploaded,matched,not_uploaded = m.upload(path)
    completed_ids = set()
    for fn,_id in uploaded.items():
        completed_ids.add(_id)
    for fn,_id in matched.items():
        completed_ids.add(_id)
    for fn,_id in not_uploaded.items():
        print("{} not uploaded: {}".format(fn,_id), file=stderr)
    return completed_ids

def main():
    parser = ArgumentParser()
    parser.add_argument("files", nargs="+", help="Files to upload")
    args = parser.parse_args()
    completed_ids = set()
    for file in args.files:
        if '*' in file:
            for subfile in glob(file):
                completed_ids.update(upload(subfile))
        else:
            completed_ids.update(upload(file))
    all_songs = {song["id"]:song for song in m.get_uploaded_songs() if song["id"] in completed_ids}
    albums = set()
    for _id in completed_ids:
        if _id[0] == "T": # gmusic track
            print("https://play.google.com/music/m/{}".format(_id))
        else:
            albums.add("https://play.google.com/music/listen#/album///" + quote_plus(all_songs[_id]["album"]))
    print("\n".join(albums))

if __name__ == "__main__":
    main()