#!/usr/bin/env python3
import requests
from datetime import datetime, timedelta

with open(".bottoken") as f:
    token = f.read().strip()
t = '\u2705'
f = '\u274c'

class Channel:
    category = ("1063529720538484786", "status")
    login = ("1063529561486270494", "login")
    gate = ("1063529595162337371", "gate")
    dc = ("1063529626263101490", "materia")
    server = ("1063529649507942501", "sophia")

def get(*args, **kwargs):
    if "headers" not in kwargs:
        kwargs["headers"] = {}
    kwargs["headers"]["Authorization"] = f"Bot {token}"
    return requests.get(*args, **kwargs)

def patch(*args, **kwargs):
    if "headers" not in kwargs:
        kwargs["headers"] = {}
    kwargs["headers"]["Authorization"] = f"Bot {token}"
    return requests.patch(*args, **kwargs)

def update_channel_name(channel, status):
    channel_id, name = channel
    if status is None: # timestamping
        dt = datetime.now() + timedelta(hours=1)
        time = "{hour}:{minute}".format(hour=dt.hour, minute=dt.minute)
        return patch("https://discord.com/api/channels/{}".format(channel_id), json={"name": f"{name}-{time}-AEDT"})
    channel_data = get("https://discord.com/api/channels/{}".format(channel_id)).json()
    if (status and t not in channel_data["name"]) or (not status and t in channel_data["name"]):
        return patch("https://discord.com/api/channels/{}".format(channel_id), json={"name": f"{name}{t if status else f}"})
    else:
        return True

def a(obj):
    if not isinstance(obj, bool) and str(obj.status_code)[0] != "2":
        print(obj.headers)
        print(obj.json())

data = requests.get("https://is.xivup.com/indexdata").json()
a(update_channel_name(Channel.login, data["Realms"]["LoginzServer"]["Status"] == 1))
a(update_channel_name(Channel.gate, data["Realms"]["GatezServer"]["Status"] == 1))
a(update_channel_name(Channel.dc, data["DCs"]["Materia"] == 1))
a(update_channel_name(Channel.server, data["Realms"]["Sophia"]["Status"] == 1))
a(update_channel_name(Channel.category, None))