#!/bin/bash
source /backup/env.sh

borg create "$@"                                 \
    --stats                                      \
    --one-file-system                            \
    --compression auto,zstd,3                    \
    --exclude /backup                            \
    --exclude /root/.cache                       \
    --exclude /opt/nvidia                        \
    --exclude **/cuda**                          \
    --exclude /var/cache                         \
    --exclude /usr/share                         \
    --exclude **/.pyenv                          \
    --exclude **/.cache                          \
    --exclude **/cache                           \
    --exclude **/Cache                           \
    --exclude **/Code\ Cache                     \
    --exclude **/ccache                          \
    --exclude **/.git                            \
    --exclude **/.env                            \
    --exclude **/.conda                          \
    --exclude **/miniconda3                      \
    --exclude **/.docker                         \
    --exclude **/.nuget                          \
    --exclude **/User\ Data                      \
    --exclude **/QtWebEngine/Default             \
    --exclude **/Service\ Worker                 \
    --exclude **/FL\ Studio                      \
    --exclude **/modules                         \
    --exclude **/Lib                             \
    --exclude **/site-packages                   \
    --exclude **/node_modules                    \
    --exclude **/Persistent                      \
    --exclude **/AppData/Roaming/Cakewalk        \
    --exclude **/AppData/Local/Temp              \
    --exclude **/Packages                        \
    --exclude **/Package\ Cache                  \
    --exclude /tmp                               \
    --exclude /usr/lib                           \
    --exclude **/MediaCover                      \
    --exclude **venv                             \
    --exclude /home/**/.local/lib                \
    --exclude **/virtualenv                      \
    --exclude **/virtualenvs                     \
    --exclude **/Temp                            \
    "$REPO::{hostname}-{now:%Y-%m-%d}"           \
    /                                            \
    /mnt/c/Users                                 \
    /mnt/c/ProgramData