#!/usr/bin/env python3
# pip install selenium, you'll also need firefox installed

import contextlib
from selenium import webdriver
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from sys import argv, stderr, stdin

if len(argv) > 1:
    if argv[1] == "-":
        urls = [line for line in stdin]
    else:
        urls = argv[1:]
    with contextlib.closing(webdriver.Firefox()) as driver:
        for i in urls:
            driver.get(i)
            WebDriverWait(driver, 10).until(lambda driver: driver.find_element_by_tag_name('video'))
            print(driver.title, file=stderr)
            print(driver.find_element_by_tag_name("video").get_attribute("src"))