#!/usr/bin/env python3
# proof of concept for an idea i've had for a while
from peewee import *

db = SqliteDatabase("wownav.db")

class BaseModel(Model):
    def __init__(self, *args, **kwargs):
        super(*args, **kwargs)
        self.save()
    class Meta:
        database = db

class Faction(BaseModel):
    name = CharField()
    hostile_to = ForeignKeyField(Faction)

class City(BaseModel):
    name = CharField()
    faction = ForeignKeyField(Faction, backref="cities")

class Location(BaseModel):
    name = CharField()
    city = ForeignKeyField(City, backref="locations")
    lat = DoubleField()
    lon = DoubleField()

class Mode(BaseModel):
    name = CharField()

class Path(BaseModel):
    start_city = ForeignKeyField(City, backref="paths_start")
    dest_city = ForeignKeyField(City, backref="paths_dest")
    start_loc = ForeignKeyField(Location, backref="paths_start")
    dest_loc = ForeignKeyField(Location, backref="paths_dest")
    seconds = IntegerField()
    mode = ForeignKeyField(Mode, backref="paths")
    danger = BooleanField() # to <faction> players from npcs
    faction = ForeignKeyField(Faction, backref="paths")

if __name__ == "__main__":
    db.connect()
    db.create_tables([Faction,City,Location,Mode,Path])

    Neutral = Faction(name="Neutral")
    Alliance = Faction(name="Alliance")
    Horde = Faction(name="Horde", hostile_to=Alliance)
    Alliance.hostile_to = Horde

    Boralus = City(name="Boralus", faction=Alliance)
    DazarAlor = City(name="Dazar'alor", faction=Horde)

    TradewindsFlightMaster = Location(name="Tradewinds Market Flight Master", city=Boralus, lat=67, lon=14.84)
    BFA_Alliance_PVP_Vendor = Location(name="BFA Alliance PVP Vendor", city=Boralus, lat=55.81, lon=25.16)

    GreatSealFlightMaster = Location(name="Great Seal Flight Master", city=DazarAlor, lat=51.51, lon=41.08)
    MugumbalaFlightMaster = Location(name="Mugumbala Flight Master", city=DazarAlor, lat=35.87, lon=84.52)
    BFA_Horde_PVP_Vendor = Location(name="BFA Horde PVP Vendor", city=DazarAlor, lat=32.28, lon=89.46)

    GroundMount = Mode(name="Ground mount")
    GoblinGlider = Mode(name="Goblin Glider")
    FlightMaster = Mode(name="Flight Master")

    tw_to_pvp = Path(start_city=Boralus,
                     dest_city=Boralus,
                     start_loc=TradewindsFlightMaster,
                     dest_loc=BFA_Alliance_PVP_Vendor,
                     seconds=17,
                     mode=GroundMount,
                     danger=False,
                     faction=Alliance)
    gs_to_pvp = Path(start_city=DazarAlor,
                     dest_city=DazarAlor,
                     start_loc=GreatSealFlightMaster,
                     dest_loc=BFA_Horde_PVP_Vendor,
                     seconds=62,
                     mode=GoblinGlider,
                     danger=True,
                     faction=Horde)
    gs_to_mug = Path(start_city=DazarAlor,
                     dest_city=DazarAlor,
                     start_loc=GreatSealFlightMaster,
                     dest_loc=MugumbalaFlightMaster,
                     seconds=37,
                     mode=FlightMaster,
                     danger=False,
                     faction=Horde)
    mug_to_pvp = Path(start_city=DazarAlor,
                      dest_city=DazarAlor,
                      start_loc=MugumbalaFlightMaster,
                      dest_loc=BFA_Horde_PVP_Vendor,
                      seconds=7,
                      mode=GroundMount,
                      danger=False,
                      faction=Horde)