#!/usr/bin/env python3
import discord
import peewee
from peewee import *

client = discord.Client()
db = SqliteDatabase("logs.db")
# install MySQLdb or pymysqlthen uncomment
# db = MySQLDatabase("logs", host="localhost", port=3306, user="root", passwd="")

class BaseModel(Model):
    class Meta:
        database = db

class Author(BaseModel):
    discriminator = CharField()
    id = CharField(primary_key=True)
    username = CharField()

class Server(BaseModel):
    name = CharField()
    id = CharField(primary_key=True)

class Channel(BaseModel):
    name = CharField()
    server = ForeignKeyField(Server, related_name="channels")
    id = CharField(primary_key=True)

class Message(BaseModel):
    author = ForeignKeyField(Author, related_name="messages")
    server = ForeignKeyField(Server, related_name="messages")
    channel = ForeignKeyField(Channel, related_name="messages")
    content = CharField()
    id = CharField(primary_key=True)
    timestamp = DateField()

db.connect()
try:
    db.create_tables([Author, Server, Channel, Message])
except OperationalError:
    pass

@client.event
async def on_message(message):
    if message.author != client.user:
        return
    if message.content.startswith("save"):
        await client.delete_message(message)
        x = 0
        async for logline in client.logs_from(message.channel, limit=30000):
            try:
                author = Author.get(id=logline.author.id)
            except Author.DoesNotExist:
                author = Author.create(id=logline.author.id, username=logline.author.name, discriminator=logline.author.discriminator)
            try:
                server = Server.get(id=logline.server.id)
            except Server.DoesNotExist:
                server = Server.create(id=logline.server.id, name=logline.server.name)
            try:
                channel = Channel.get(id=logline.channel.id)
            except Channel.DoesNotExist:
                channel = Channel.create(id=logline.channel.id, name=logline.channel.name, server=server)
            msg = Message.create(author=author, channel=channel, server=server, content=logline.content, id=logline.id, timestamp=logline.timestamp)
            x += 1
            print(x, end="\r")
        print("Saved {} messages from {}".format(x, message.channel.name))

@client.event
async def on_ready():
    print("Logged in as {} ({})".format(client.user.name, client.user.id))
    if client.user.bot:
        print(discord.utils.oauth_url(client.user.id, permissions=discord.Permissions(74752)))

try:
    with open(".bottoken") as f:
        creds = f.read()
        if "." in creds:
            client.run(creds.strip(), bot=False)
        else:
            client.run(creds.strip())
finally:
    db.close()
    client.close()