<?php

$passwdfile = "/path/to/file";
$logpath = "/path/to/file"; // should be a csv file with date,lat,long,hor-acc

// For json
foreach (apache_request_headers() as $header => $value) { if ($header == "Accept") { $accept = $value; } }

// Variable checks
$allowed = isset($_GET['allowed']);
if ($allowed && !$_GET['allowed'] == file_get_contents($passwdfile)) {
  die("Sorry, this needs a password now.<form><input type=text name=allowed><input type=submit></form>");
}
$nocir = !isset($_GET['nocircles']);
if (isset($_GET['count'])) {
  $count = intval($_GET['count']);
} else {
  $count = 10;
}

// Getting data
if (isset($_GET['date']) && intval($_GET['date']) != 0 && strlen($_GET['date']) == 8) {
  $date = intval($_GET['date']);
  $datarr = explode("\n", shell_exec("grep $date $logpath --color=never"));
  array_pop($datarr);
} else {
  $datarr = explode("\n", shell_exec("tail -n$count $logpath"));
}

// Correcting for allowed data
$last = str_getcsv(array_pop($datarr));
if (!$allowed) $last = array($last[0], substr($last[1],0,6), substr($last[2],0,6));

// Creating static image url
$imageurl = "https://maps.googleapis.com/maps/api/staticmap?scale=2&format=jpg&zoom=";
if ($allowed) $imageurl .= "18";
else $imageurl .= "15";
$imageurl .= "&center=" . $last[1] . "," . $last[2];
if ($allowed) $imageurl .= "&markers=" . $last[1] . "," . $last[2];

// Json returning
if (isset($_GET['json'])) {
    header("Content-Type: application/json");
    $arr = array();
    foreach ($datarr as $item) {
        $tmp = str_getcsv($item);
        if (!$allowed) $tmp = array($tmp[0], substr($tmp[1],0,6), substr($tmp[2],0,6), "1111");
        $arr[] = $tmp;
    }
    echo json_encode(array("markers" => $arr, "imageurl" => $imageurl));
    die();
}

// Mobile support {
require_once 'Mobile_Detect.php'; // http://mobiledetect.net/ remove this block if you don't need this functionality
$detect = new Mobile_Detect;
if (isset($_GET['mobile']) || $detect->isMobile()) { ?>
  <head>
    <meta http-equiv="refresh" content="60">
    <script>
      document.addEventListener('DOMContentLoaded',function(){
        var w = Math.floor(Math.max(document.documentElement.clientWidth, window.innerWidth || 0) / 2)
        var h = Math.floor(Math.max(document.documentElement.clientHeight, window.innerHeight || 0) / 2)
        document.getElementById('i').src = "<?php echo $imageurl; ?>&size=" + w + "x" + h;
      });
    </script>
  </head>
  <body>
    <img src="nothing" id="i" />
  </body>
<?php die();}
// }

// Generating lists of markers/circles
if ($allowed) {
  $markers = "[";
  if ($nocir) {
    $circles = "[";
    $ciroptions = "{strokeColor:'#FF0000',strokeOpacity:0.8,strokeWeight:2,fillColor:'#AA0000',fillOpacity:0.2,map:map";
  }
  foreach ($datarr as $item) {
    $item = str_getcsv($item);
    $markers .= 'new google.maps.Marker({map: map, position: new google.maps.LatLng(' . $item[1] . ', ' . $item[2] . '),title: "' . $item[0] . ' to ' . $item[3] . 'm",icon: "http://maps.google.com/mapfiles/ms/icons/red-dot.png"}),';
    if ($nocir) {
      $circles .= 'new google.maps.Circle(' . $ciroptions . ',radius: ' . $item[3] . '}),';
    }
  }
  $markers .= ']';
  if ($nocir) {
    $circles .= ']';
  }
}

// Start html
?>
<!DOCTYPE html>
<html>
  <head>
<?php if ($count < 50) { ?>
    <meta http-equiv="refresh" content="60">
<?php } ?>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
    <style type="text/css">
      html { height: 100% }
      body { height: 100%; margin: 0; padding: 0 }
      #map-canvas { height: 100% }
    </style>
    <script type="text/javascript"
      src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCE7QCD1wjjjspuEa7ABtKGpJxttNOgtIU&sensor=false">
    </script>
    <script type="text/javascript">
      var geocoder;
      var map;
      var markers;
      var circles;
      var topcircle;
<?php if (!$allowed) { ?>
      var data = <?php echo json_encode($last); ?>;
      var coords = [new google.maps.LatLng(data[1], data[2])];
<?php } ?>
      function initialize() {
        geocoder = new google.maps.Geocoder();
        var mapOptions = {
          center: <?php echo 'new google.maps.LatLng(' . $last[1] . ', ' . $last[2] . ')'; ?>,
          zoom: <?php if (isset($_GET['zoom'])) { echo intval($_GET['zoom']); } else { if ($allowed) { echo "18"; } else { echo "15"; } }; echo "\n"; ?>
        };
        map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);
<?php   if ($allowed) { ?>
        markers = <?php echo $markers; ?>;
        markers[markers.length-1].setOptions({animation:google.maps.Animation.DROP,icon:"http://maps.google.com/mapfiles/ms/icons/blue-dot.png",zIndex:100});
        var coords = [];
        for (i=0;i<markers.length;i++) {
            coords.push(markers[i].getPosition());
        }
        var recentPath = new google.maps.Polyline({
          path: coords,
          geodesic: true,
          strokeColor: '#FF0000',
          strokeOpacity: 1.0,
          strokeWeight: 2
        });
        recentPath.setMap(map);
<?php   if ($nocir) { ?>
        circles = <?php echo $circles; ?>;
        for (i=0;i<circles.length;i++) {
            circles[i].bindTo('center', markers[i], 'position');
            markers[i]._myCircle = circles[i];
            circles[i].title = markers[i].title;
        }
        topcircle = circles[circles.length-1];
        topcircle.setOptions({fillColor: '#0000AA', strokeColor: '#0000FF', url: "<?php echo $_SERVER['REQUEST_URI']."&nocircles" ?>"});
        google.maps.event.addListener(topcircle, 'click', function() {
                window.location = topcircle.url;
        });
<?php   } ?>
<?php   } else { ?>
        var infowindow = new google.maps.InfoWindow({
            content: "blha303's last recorded location (accurate to 1.1km approx)"
        });
        var circle = new google.maps.Circle({
            map: map,
            center: coords[coords.length-1],
            radius: 1100,
            fillColor: '#AA0000',
            fillOpacity: 0.1
        });
        google.maps.event.addListener(circle, 'click', function() {
            infowindow.open(map,circle);
        });
<?php   } ?>
      }
      google.maps.event.addDomListener(window, 'load', initialize);
    </script>
  </head>
  <body>
    <div id="map-canvas"/>
  </body>
</html>