#!/usr/bin/env python
# v4
# known bugs:
# * very long words may break all the things or end up longer than the maximum limit

__usage__ = "{} $network <lyrics"
__example__ = """
$ {} 172.16.1.0/30 <<EOF
this is a test
this is only a test
EOF
"""

import sys, ipaddress
from string import ascii_lowercase,ascii_uppercase

if len(sys.argv) < 2 or sys.stdin.isatty():
    print(__usage__.format(sys.argv[0]))
    print(__example__.format(sys.argv[0]))
    sys.exit(2)

subnet = iter(ipaddress.ip_network(sys.argv[1]))


def filter(l):
    return "".join([c for c in l if c in ascii_lowercase+ascii_uppercase+"_"])


def get_ip_for_line(line):
    l = []
    overflow = []
    for word in line.strip().split():
        word = filter(word.lower())
        if not l or (len(".".join(l)) + len(word) < 253) and not overflow:
            if len(word) > 60:
                while word:
                    l.append(word[:60])
                    word = word[60:]
            else:
                l.append(word)
        else:
            overflow.append(word)
    ip = ".".join(str(next(subnet)).split(".")[::-1])
    print("^{}.in-addr.arpa:{}:86400".format(ip, ".".join(l)))
    if overflow:
        get_ip_for_line(" ".join(overflow))


for line in sys.stdin:
    try:
        get_ip_for_line(line)
    except StopIteration:
        print("out of IPs!", file=sys.stderr)
        break