#!/usr/bin/env python3
from requests import get
from interactions import slash_command, SlashContext, Client, slash_option, OptionType, auto_defer, Embed, check, AutocompleteContext, listen
from os import environ

suburbs = {f"{d['locality']} {d['state']}": d for d in get("https://www.matthewproctor.com/Content/postcodes/australian_postcodes.json").json()}

bot = Client(token=environ["BOT_TOKEN"])
guilds = [353071720342487040]

@slash_command(name="fuel", description="Check Fair Fuel prices (RACQ)", scopes=guilds)
@slash_option(name="location", description="Suburb", required=True, opt_type=OptionType.STRING, autocomplete=True)
async def fuel(ctx: SlashContext, location: str):
    suburb = suburbs[location]
    fair_response = get("https://www.racq.com.au/ajaxpages/fuelprice/fairfuelpricesapi.ashx", params={"lat": suburb["lat"], "lng": suburb["long"], "fueltype": 37}).json()
#    area_response = get(f"https://www.racq.com.au/ajaxpages/fuelprice/fuelpricesapi.ashx?lat={suburb['lat']}&lng={suburb['long']}&fueltype=37").json()
    embed = Embed(title="Area prices").add_field(name="RACQ", value=f"https://www.racq.com.au/car/fair-fuel-prices?phracq_body_0_phracq_contentcontainer_0_FuelTypesDDL=37&location={location.replace(' ', '%20')}").add_field(name="PetrolSpy", value=f"https://petrolspy.com.au/map/latlng/{suburb['lat']}/{suburb['long']}")
#    for station in area_response["Stations"]:
#        embed.add_field(name=station["Name"], value=station["Price"])
    await ctx.send(f"Fair Fuel price in {fair_response['FairPrice']['Location']}: {fair_response['FairPrice']['RoundedPrice']}{' :thumbsup:' if fair_response['FairPrice']['PriceIndicator'] == 2 else ''}", embed=embed)

@fuel.autocomplete("location")
async def autocomplete(ctx: AutocompleteContext):
    inp = ctx.input_text.lower()
    results = [a for a in suburbs if a.lower().startswith(inp)][:25]
    await ctx.send(choices=[{"name": r, "value": r} for r in results])

@listen()
async def on_startup():
    print("Bot started")

bot.start()