# pip3 install curses-menu xmltodict requests bs4
# python 3.7 yo
from cursesmenu import CursesMenu
from cursesmenu.items import SubmenuItem, FunctionItem
import requests
import xmltodict
from bs4 import BeautifulSoup as Soup
from sys import stderr
import os
from urllib.parse import urlparse, unquote

system_data = xmltodict.parse(requests.get("https://ia801407.us.archive.org/23/items/no-intro-rom-sets/no-intro-rom-sets_files.xml").text)
archive_path = "https://ia801407.us.archive.org/view_archive.php?archive=/23/items/no-intro-rom-sets/"

def download_file(url):
    if url[0] != "h":
        url = "https:" + url
    r = requests.get(url, stream=True)
    if r.status_code == 200:
        with open(os.path.basename(unquote(urlparse(url).path)), "wb") as f:
            for chunk in r:
                print("*")
                f.write(chunk)

def search_submenu(filelist):
    " doesn't work "
    term = input("Enter search term")
    results = []
    for row in filelist.findAll("tr")[1:]:
        dest_fn = row.find("td")
        if ".zip" in dest_fn.text:
            if term.lower() in dest_fn.text.split(".zip")[0].lower():
                results += (dest_fn.text.split(".zip")[0], dest_fn.find("a")["href"])
    search_menu = CursesMenu("Search", "")
    for title, url in results:
        item = FunctionItem(title, download_file, [url])
        search_menu.append_item(item)
    search_menu.show()

def generate_submenu(filename):
    filelist = Soup(requests.get(archive_path + filename).text, "html.parser").find("table", {"class": "archext"})
    system_menu = CursesMenu(filename, "Select a file to download")
#    system_menu.append_item(FunctionItem("Search...", search_submenu, [filelist]))
    for row in filelist.findAll("tr")[1:]:
        dest_fn = row.find("td")
        if ".zip" in dest_fn.text:
            item = FunctionItem(dest_fn.text.split(".zip")[0], download_file, [dest_fn.find("a")["href"]])
            system_menu.append_item(item)
    system_menu.show()

def main():
    systems_menu = CursesMenu("System Menu", "Select the system to browse roms")
    for system in system_data["files"]["file"]:
        if system["@name"][-4:] == ".zip":
            item = FunctionItem(system["@name"], generate_submenu, [system["@name"]])
            systems_menu.append_item(item)
    systems_menu.show()

if __name__ == "__main__":
    main()