# pip3 install curses-menu xmltodict requests bs4
# python 3.7 yo
from cursesmenu import CursesMenu
from cursesmenu.items import SubmenuItem, FunctionItem
import requests
import xmltodict
from bs4 import BeautifulSoup as Soup
from sys import stderr
import os
from urllib.parse import urlparse, unquote
from getpass import getuser
from subprocess import Popen

system_data = xmltodict.parse(requests.get("https://ia801407.us.archive.org/23/items/no-intro-rom-sets/no-intro-rom-sets_files.xml").text)
archive_path = "https://ia801407.us.archive.org/view_archive.php?archive=/23/items/no-intro-rom-sets/"

# openemu support
directory = os.path.join("/Users", getuser(), "Library", "Application Support", "OpenEmu", "Game Library", "roms", "Automatically Import")
if not os.path.exists(directory):
    directory = ""

def download_file(url):
    if url[0] != "h":
        url = "https:" + url
    r = requests.get(url, stream=True)
    if r.status_code == 200:
        with open(os.path.join(directory, os.path.basename(unquote(urlparse(url).path))), "wb") as f:
            for chunk in r:
                print("*")
                f.write(chunk)

def generate_submenu(filename):
    filelist = Soup(requests.get(archive_path + filename).text, "html.parser").find("table", {"class": "archext"})
    system_menu = CursesMenu(filename, "Select a file to download")
    for row in filelist.findAll("tr")[1:]:
        dest_fn = row.find("td")
        if ".zip" in dest_fn.text:
            display_fn = dest_fn.text.split(".zip")[0]
            if "/" in display_fn:
                display_fn = display_fn.split("/",1)[1]
            item = FunctionItem(display_fn, download_file, [dest_fn.find("a")["href"]])
            system_menu.append_item(item)
    system_menu.show()

def main():
    systems_menu = CursesMenu("System Menu", "Select the system to browse roms")
    for system in system_data["files"]["file"]:
        if system["@name"][-4:] == ".zip":
            item = FunctionItem(system["@name"], generate_submenu, [system["@name"]], should_exit=True)
            systems_menu.append_item(item)
    systems_menu.show()

if __name__ == "__main__":
    main()