#!/usr/bin/env python3
# $ python3 toornamenter.py '1349047821760815104,Test label,test_label,1,1,1
# 1262174713922625536,Test label,test_label,1,1,1'
# yes that's a newline in there. takes csv as long as it's purely comma separated values,
# no quotes or escaped commas supported, sorry
import requests
from argparse import ArgumentParser
from os import environ

x = "custom_field_create[{}]"# 

def main():
    """ toornament_id,"Label of field",slug_of_field,position(sequential)(int),required(boolean)(int),public(boolean)(int) """
    parser = ArgumentParser()
    parser.add_argument("tids", help='newline-separated list of comma-separated data: toornament_id,"Label of field",slug_of_field,position(sequential)(int),required(boolean)(int),public(boolean)(int)')
    parser.add_argument("--email", default=environ.get("TOORNAMENT_EMAIL", None))
    parser.add_argument("--password", default=environ.get("TOORNAMENT_PASSWORD", None))
    args = parser.parse_args()
    fields = {}
    for field in args.tids.split("\n"):
        tid,label,slug,pos,req,pub = field.split(",")
        if not tid in fields:
            fields[tid] = []
        fields[tid].append({
            x.format("label"): label,
            x.format("machineName"): slug,
            x.format("position"): int(pos),
            x.format("required"): int(req),
            x.format("public"): int(pub)
        })
    s = requests.Session()
    csrf1 = s.get("https://account.toornament.com/login/").text.split('name="_token" value="',1)[1].split('"',1)[0]
    login = s.post("https://account.toornament.com/login_check", data={"_username": args.email, "_password": args.password, "_token": csrf1})
    for tid in fields:
        csrf2 = s.get("https://organizer.toornament.com/tournaments/{}/participants/settings/custom-field/create?target-type=player&type=text".format(tid)).text.split('name="custom_field_create[_token]" value="',1)[1].split('"',1)[0]
        for field in fields[tid]:
            field.update({x.format("_token"): csrf2})
            field_req = s.post("https://organizer.toornament.com/tournaments/{}/participants/settings/custom-field/create".format(tid), params={"target-type": "player", "type": "text"}, data=field)
            print("Added {} to {}".format(repr(field), tid))

if __name__ == "__main__":
    main()
