#!/usr/bin/env python3
# reqs: requests, beautifulsoup4
from bs4 import BeautifulSoup as Soup
from requests import get
from argparse import ArgumentParser
import sys

CLIENT_ACCESS_TOKEN = "" # generate at https://genius.com/api-clients

def main():
    parser = ArgumentParser(prog="genius")
    parser.add_argument("term", help="Search term")
    parser.add_argument("-n", help="Select different result number (defaults to 1)", type=int, default=1)
    args = parser.parse_args()
    data = get("https://api.genius.com/search", headers={"Authorization": "Bearer " + CLIENT_ACCESS_TOKEN}, params={"q": args.term}).json()
    if not data["response"]["hits"]:
        print("No results", file=sys.stderr)
        return 1
    if len(data["response"]["hits"]) < args.n:
        print("Not enough results ({} returned)".format(len(data["response"]["hits"])), file=sys.stderr)
        return 2
    result = data["response"]["hits"][args.n-1]["result"]
    print("{0}{1} result: {title} by {primary_artist[name]}".format(args.n,
                                                                    "st" if args.n == 1 else
                                                                    "nd" if args.n == 2 else
                                                                    "rd" if args.n == 3 else "th",
                                                                    **result), file=sys.stderr)
    soup = Soup(get("http://genius.com" + result["path"], "html.parser").text)
    print(soup.find('lyrics').text)
    return 0

if __name__ == "__main__":
    try:
        sys.exit(main())
    except KeyboardInterrupt:
        print("Aborting", file=sys.stderr)
