#!/usr/bin/env python3
# txtrecord_encode.py [-h] [--format '{0} IN TXT "{1}"'] input.png logo.example.com
import base64
import sys
from argparse import ArgumentParser
from textwrap import wrap

def main():
    parser = ArgumentParser()
    parser.add_argument("input", help="Input filename (or - for stdin)")
    parser.add_argument("domain", help="Target domain")
    parser.add_argument("--format", help="DNS record format, where {0} is the target domain (without trailing dot), and {1} is the record text (defaults to bind/named \"{0}. IN TXT '{1}'\")", default="{0}. IN TXT '{1}'")
    args = parser.parse_args()
    if args.input == "-":
        inp = sys.stdin.buffer.read()
    else:
        with open(args.input,"rb") as f:
            inp = f.read()
    enc = base64.b64encode(inp).decode("utf-8")
    tot = len(enc)
    tmp = 0
    for n,block in enumerate(wrap(enc,65000)):
        tmp += len(block)
        print("\n".join(args.format.format((str(n) if n else "") + sys.argv[2], "{}{}".format("{%03d}" % _n, s)) for _n, s in enumerate(wrap(block,249))))
        if tmp != tot:
            print(args.format.format((str(n) if n else "") + sys.argv[2], "{}{}".format("{nxt}", str(n+1) + sys.argv[2] + ".")))
    return 0

if __name__ == "__main__":
    sys.exit(main())