#!/usr/bin/env python3
# txtrecord_encode.py input.png logo.example.com
import base64
import sys
from textwrap import wrap
with open(sys.argv[1],"rb") as f:
    enc = base64.b64encode(f.read()).decode("utf-8")

# '%04d' and '247' may need to be updated for large files to ensure the line count doesn't push the length
# longer than 255 bytes
tot = len(enc)
tmp = 0
for n,block in enumerate(wrap(enc,65000)):
    tmp += len(block)
    print("\n".join("{0}. IN TXT '{1}{2}'".format((str(n) if n else "") + sys.argv[2], "{%03d}" % _n, s) for _n, s in enumerate(wrap(block,249))))
    if tmp != tot:
        print("{0}. IN TXT '{1}{2}.".format((str(n) if n else "") + sys.argv[2], "{nxt}", str(n+1) + sys.argv[2]))
#print("\n".join("%s. IN TXT '{%03d}%s'" % (sys.argv[2], n,s) for n,s in enumerate(wrap(enc,249))))
