#!/usr/bin/env python3
# txtrecord_decode.py output.png logo.example.com
import dns.resolver # pip3 install dnspython
import base64
import sys
def parse_records(name):
    _next = ""
    print("{}".format(name), file=sys.stderr)
    q = dns.resolver.query(name,"TXT").response.answer[0]
    out = b""
    for line in sorted(_.strings[0] for _ in q):
        if chr(line[0]) == "{":
            if chr(line[1]) == "n":
                _next = line.split(b"}",1)[1].decode("utf-8")
                continue
            try:
                out += line.split(b"}",1)[1]
            except IndexError:
                pass
    return out, _next

out = b""
name = sys.argv[2]
while True:
    next_out, name = parse_records(name)
    out += next_out
    if not name:
        break

with open(sys.argv[1],"wb") as f:
    f.write(base64.b64decode(out))
