#!/usr/bin/env python3
# txtrecord_decode.py [-h] output.png logo.example.com
import dns.resolver # pip3 install dnspython
import base64
import sys
from argparse import ArgumentParser
def parse_records(name):
    _next = ""
    print("{}".format(name), file=sys.stderr)
    q = dns.resolver.query(name,"TXT").response.answer[0]
    out = b""
    for line in sorted(_.strings[0] for _ in q):
        if chr(line[0]) == "{":
            if chr(line[1]) == "n":
                _next = line.split(b"}",1)[1].decode("utf-8")
                continue
            try:
                out += line.split(b"}",1)[1]
            except IndexError:
                pass
    return out, _next

def main():
    parser = ArgumentParser()
    parser.add_argument("output", help="Output filename (or - for stdout)")
    parser.add_argument("domain", help="Target domain")
    args = parser.parse_args()
    name = args.domain
    out = b""
    while True:
        next_out, name = parse_records(name)
        out += next_out
        if not name:
            break
    
    with open(sys.stdout if args.output == "-" else args.output, "wb") as f:
        f.write(base64.b64decode(out))
    return 0

if __name__ == "__main__":
    sys.exit(main())