#!/usr/bin/env python3
# A script to generate videos for songs
# usage: ./song2video.py [ext]
# ext defaults to mp3
from moviepy.editor import *
from glob import glob
from mutagen import File
import sys

#points
ART_TOP_LEFT = (620,45)
ART_SIZE = (585,585)
TEXT_TOP_LEFT = (85,60)
TEXT_SIZE = (510,565)

for fn in glob("*." + (sys.argv[1] if len(sys.argv) > 1 else "mp3")):
    data = File(fn)
    audio = AudioFileClip(fn)
    text = TextClip("You are listening to\n\n{title[0]}\n\nBy {artist[0]}\n\nFrom {album[0]}".format(**data),
                    size=TEXT_SIZE,
                    color="white",
                    font="Corbel",
                    kerning=5,
                    fontsize=50,
                    method="caption",
                    align="West").set_position(TEXT_TOP_LEFT).set_duration(audio.duration).set_audio(audio)
    cover = ImageClip("cover.jpg").set_position(ART_TOP_LEFT).set_duration(audio.duration).resize(ART_SIZE)
    cvc = CompositeVideoClip([text, cover], size=(1280,720)).set_fps(60)
    cvc.write_videofile(fn.replace(".mp3", ".mp4"))
