#!/usr/bin/env python3
from flask import Flask,request,make_response
from shlex import quote
from subprocess import check_output
import socket

app = Flask(__name__)

@app.route('/')
def index():
    return """<form method="post" action="process">
    <input type="text" name="host"><br>
    <input type="radio name="service" id="ping"><label for="ping">Ping</label><br>
    <input type="radio name="service" id="mtr"><label for="mtr">mtr</label><br>
    <input type="submit"></form>
"""

@app.route("/process", methods=["POST"])
def process():
    host = request.form.get("host", "8.8.8.8")
    try:
        # Is it an ip?
        _ = socket.inet_aton(host)
    except OSError:
        # Well it's not ipv4,
        try:
            _ = socket.inet_pton(socket.AF_INET6, host)
        except OSError:
            # Not ipv6 either. We'll try resolving dns
            try:
                host = socket.gethostbyname(host)
            except socket.gaierror:
                return "We only support ipv4/ipv6/valid domains\n"
        else:
            pass # host is ipv6
    else:
        pass # host is ipv4
    host,service = quote(request.form.get("host", "8.8.8.8")),request.form.get("service","ping")
    print("Processing request {},{} from {} {}".format(host,service, request.environ["REMOTE_ADDR"], request.headers.get("User-Agent")))
    if service == "ping":
        resp = make_response(check_output(["ping", "-i", "0.2", "-q", "-c", "4", host]))
    elif service == "mtr":
        resp = make_response(check_output(["mtr", "-c", "1", "--report-wide", "-m", "60", "-b", host]))
    else:
        return "oi"
    print(" Completed request {},{} from {} {}".format(host,service, request.environ["REMOTE_ADDR"], request.headers.get("User-Agent")))
    resp.headers["Content-Type"] = "text/plain"
    return resp

if __name__ == "__main__":
    app.run(port=5001)