#!/usr/bin/env python3
from requests import post as _post
import urllib3
urllib3.disable_warnings(category=urllib3.exceptions.InsecureRequestWarning)

def post(*args, **kwargs):
    kwargs["verify"] = False
#    if not "headers" in kwargs:
#        kwargs["headers"] = {}
#    kwargs["headers"]["Content-Type"] = "application/json"
    return _post(*args, **kwargs)

def query(host, port, function, data={}):
    if function == "HealthCheck":
        data = {"ClientCustomData": ""}
    return post(f"https://{host}:{port}/api/v1", json={"function": function, "data": data}).json()

def main():
    from argparse import ArgumentParser
    parser = ArgumentParser()
    parser.add_argument("host")
    parser.add_argument("function")
    parser.add_argument("--port", default=7777, type=int)
    args = parser.parse_args()
    print(query(args.host, args.port, args.function))
    return 0

if __name__ == "__main__":
    from sys import exit
    exit(main())
