#!/usr/bin/env python
import voicemeeterlib # pip install voicemeeter-lib
from subprocess import check_output
from time import sleep
DEBUG = False
DEVICE = "Headphones (Bose QuietComfort 35 Series 2 Stereo)" # TODO update with your device name
CMD = "Get-PnpDevice -presentonly | Where-Object FriendlyName -eq '{}'"
def debug(*msg):
    if DEBUG: print(*msg)
while True:
    with voicemeeterlib.api('banana') as vm:
        bus_device = vm.bus[1].device.name == DEVICE
        debug()
        debug(bus_device)
        if check_output(["powershell", "-Command", CMD.format(DEVICE)]):
            if not bus_device: vm.bus[1].device.wdm = DEVICE
            debug(True, bus_device)
        else:
            if bus_device: vm.bus[1].device.wdm = ""
            debug(False, bus_device)
        bus_device = vm.bus[1].device.name == DEVICE
        debug(bus_device)
    sleep(1)