import machine
import utime

notes = {
    "B3": 247,
    "E4": 330,
    "FS4": 370,
    "GS4": 415,
    "A4": 440,
    "D7": 2349,
}

green = machine.Pin(21, machine.Pin.OUT)
green.value(0)

buzzer = machine.PWM(machine.Pin(22))

rtc=machine.RTC()
timestamp=rtc.datetime()
#file = open("test","a")
#file.write("%04d-%02d-%02d %02d:%02d:%02d.%04d\n"%(timestamp[0:3] + timestamp[4:8]))
#file.close()

minute = [
    ("D7", 0.1)
]
hour = [
    ("GS4", 0.4),
    ("E4", 0.4),
    ("FS4", 0.4),
    ("B3", 0.4),
    ("", 0.4),
    ("", 0.4),
    ("B3", 0.4),
    ("FS4", 0.4),
    ("GS4", 0.4),
    ("E4", 0.4)
]

while True:
    timestamp=rtc.datetime()
#    print("%04d-%02d-%02d %02d:%02d:%02d.%04d"%(timestamp[0:3] + timestamp[4:8]))
    song = []
    # internal RTC starts on 2021-01-01 00:00:01.0000
    if timestamp[6]-1 == 0:
        if timestamp[5] == 0:
            song = hour
        else:
            song = minute
        for note,length in song:
            if length > 0.5:
                raise Exception
            green.value(1)
            if note:
                buzzer.freq(notes[note])
                buzzer.duty_u16(1000)
            utime.sleep(length)
            green.value(0)
            if note:
                buzzer.duty_u16(0)
            utime.sleep(0.5-length)
        if len(song)%2 != 0:
            utime.sleep(0.5)
    else:
        utime.sleep(1)