import machine
import utime

class Notes:
    B3 = 247
    E4 = 330
    FS4 = 370
    GS4 = 415
    A4 = 440
    D6 = 1174
    E6 = 1320
    D7 = 2349

mute = list(range(0,9))+list(range(21,24))
#mute = range(0,24)
is_muted = False

buzzer = machine.PWM(machine.Pin(22))
led = machine.PWM(machine.Pin(21),5000)
led.duty_u16(0)

rtc=machine.RTC()
rtc.datetime((2021,1,1,0,  12,13,24,0))
offset = 0
ben = [
    [
        (Notes.GS4,0.4,1000,True),
        (Notes.E4,0.4,600,True),
        (Notes.FS4,0.4,1200,True),
        (Notes.B3,0.4,900,True),
        (None,0.4,1000,False),
        (None,0.4,1000,False)
    ],
    [
        (Notes.B3,0.4,900,True),
        (Notes.FS4,0.4,1200,True),
        (Notes.GS4,0.4,1000,True),
        (Notes.E4,0.4,600,True),
        (None,0.4,1000,False),
        (None,0.4,1000,False)
    ]
]

minute = [(Notes.E6, 0.1, 500, True)]
special = {
#    900: ben[0],
#    1800: ben[0] + ben[1],
#    2700: ben[0] + ben[1] + ben[0],
}

def get_hour_tune(hour):
    chimes = []
    for n in range((hour%12 or 12)):
        chimes += [(Notes.GS4,0.4,1000,True), (None,0.4,1000,False), (None,0.4,1000,False)]
#    if not is_muted:
#        return ben[0] + ben[1] + ben[0] + ben[1] + chimes
    return chimes

def init_clock():
    global offset
    # check if offset pin is pulled high: GP0-11 for 5-60 minute offset
    for n,pin in enumerate(range(0,12)):
        inp = machine.Pin(pin, machine.Pin.IN, pull=None)
        if inp.value():
            offset += (n+1)*300
            break
    m,s = divmod(offset,60)
    h,m = divmod(m,60)
#    print("init clock",offset,h,m,s)
    t = rtc.datetime()
    rtc.datetime((t[0],t[1],t[2],t[3],t[4]+h,t[5]+m,t[6]+s,t[7]))

def sleep(s,p=True):
#    if p: print("sleep %02f"%s)
    utime.sleep(s)
    
def play(song):
    tot = 0
    for note,length,vol,flash in song:
        print("freq:%d,length:%d,vol:%d,flash:%r"%(note or 0,length,vol,flash))
        if flash:
            led.duty_u16(vol*4)
        if note:
            buzzer.freq(note)
            buzzer.duty_u16(vol if not is_muted else 0)
        sleep(length, p=False)
        tot += length
        if flash:
            led.duty_u16(0)
        if note:
            buzzer.duty_u16(0)
    return 60-tot

def loop():
    global is_muted
    first = True
    while True:
        timestamp=rtc.datetime()
        y,m,d,w,h,m,s,ss = rtc.datetime()
        sec = m*60+s
        print("%04d-%02d-%02d %02d:%02d:%02d %03d"%(y,m,d,h,m,s,sec))
        is_muted = h in mute
        if first:
            first = False
            sleep(60-s)
            continue
        if m == 0:
            sleep(play(get_hour_tune(h)))
        elif sec in special and not is_muted:
            sleep(play(special[sec]))
        else:
            sleep(play(minute))


import os
logfile = open("log.txt", "a")
os.dupterm(logfile)
try:
    init_clock()
    loop()
finally:
    logfile.flush()
    logfile.close()