import machine
import utime

class Notes:
    B3 = 247
    E4 = 330
    FS4 = 370
    GS4 = 415
    A4 = 440
    D7 = 2349

buzzer = machine.PWM(machine.Pin(22))
green = machine.Pin(25, machine.Pin.OUT)
green.value(0)

rtc=machine.RTC()
offset = 0

minute = [(Notes.D7, 0.1)]
hour = [(Notes.D7, 0.4)]
#minute = [
#    (Notes.D7, 0.1)
#]
#hour = [
#    (Notes.GS4, 0.4),
#    (Notes.E4, 0.4),
#    (Notes.FS4, 0.4),
#    (Notes.B3, 0.4),
#    (None, 0.4),
#    (None, 0.4),
#    (Notes.B3, 0.4),
#    (Notes.FS4, 0.4),
#    (Notes.GS4, 0.4),
#    (Notes.E4, 0.4)
#]

def init_clock():
    global offset
    # check if offset pin is pulled high: GP0-11 for 5-60 minute offset
    for n,pin in enumerate(range(0,12)):
        inp = machine.Pin(pin, machine.Pin.IN, pull=None)
        if inp.value():
            offset += (n+1)*300
            break
    m,s = divmod(offset,60)
    h,m = divmod(m,60)
    print(offset,h,m,s)
    t = rtc.datetime()
    rtc.datetime((t[0],t[1],t[2],t[3],t[4]+h,t[5]+m,t[6]+s,t[7]))

def loop():
    while True:
        timestamp=rtc.datetime()
        print("%04d-%02d-%02d %02d:%02d:%02d.%04d"%(timestamp[0:3] + timestamp[4:8]))
        song = []
        # internal RTC starts on 2021-01-01 00:00:01.0000
        if timestamp[6]-1 == 0:
            if timestamp[5] == 0:
                song = hour
            else:
                song = minute
            for note,length in song:
                if length > 0.5:
                    raise Exception
                green.value(1)
                if note:
                    buzzer.freq(note)
                    buzzer.duty_u16(1000)
                utime.sleep(length)
                green.value(0)
                if note:
                    buzzer.duty_u16(0)
                utime.sleep(0.5-length)
            if len(song)%2 != 0:
                utime.sleep(0.5)
        else:
            utime.sleep(1)

init_clock()
loop()