import requests
from bs4 import BeautifulSoup as Soup
from tabulate import tabulate
from sys import argv

headers = ["Candidate", "Party", "Votes", "%", "Swing (%)"]

def get_data():
    soup = Soup(requests.get("http://vtr.aec.gov.au/HouseDivisionFirstPrefs-18126-236.htm").text, "html.parser")
    for row in soup.findAll('tr', id=lambda x: x and x.startswith("repeaterCandidates")):
        yield [td.text for td in row.findAll('td')]

def main():
    if len(sys.argv) > 1:
        if not sys.argv[1].isdigit():
            print "Usage: {} <column number to sort on>".format(sys.argv[0])
            return 1
        col = int(sys.argv[1])
    else:
        col = 3
    print tabulate(sorted(data, key=lambda x: float(x[col]), reverse=True), headers=headers)
    return 0

if __name__ == "__main__":
    sys.exit(main())