#!/usr/bin/env python3
# A tool to load a Bandcamp collection and print the urls for all included albums and tracks
import requests
import click
import json

def get_data(user):
    data = requests.get("https://bandcamp.com/{}".format(user)).text
    if "    item_details" not in data:
        return False
    return json.loads(
        data.split("    item_details: ")[1].split("\n")[0][:-1]
    )

@click.command()
@click.argument("user")
def print_bc_collection_urls(user):
    for url in (item["item_url"] for item in get_data(user).values()):
        click.echo(url)

if __name__ == "__main__":
    print_bc_collection_urls()