#!/usr/bin/env python3
# videos from https://tane.us/ac/nhIds.js, rename to hh00.m4a
# python3 acnhmusic.py | mpv - --loop-playlist=inf
from glob import glob
from datetime import datetime
from sys import stderr

print("#EXTM3U")

files = sorted(glob("*.m4a"))
n = datetime.now()
hour = n.hour
files = files[hour:] + files[:hour]

def hms(inp):
    s,ms = divmod(inp,1)
    m,s = divmod(s,60)
    h,m = divmod(m,60)
    return f"{h:02.0f}:{m:02.0f}:{s:02.0f}"

earlier = datetime(n.year, n.month, n.day, n.hour, 0, 0)
print(f"skip ahead {hms((n-earlier).seconds)}", file=stderr)

l = "#EXTINF:1800.0,ACNH - {0}:00\n{1}\n"
print("".join(l.format(f[:2], f) for f in files))