import Skype4Py
from irc.bot import SingleServerIRCBot

SERVER = "irc.esper.net"
PORT = 6667
CHANNEL = "#b3skypetest"
NICKNAME = "b3skypetest"
ROOM = "#stevensmith030/$a5a47aa57ec70504"
OWNER_HANDLE = "stevensmith030"

def munge(inp):
    return u"".join([a + u"\u200b" for a in inp])

def skype_handler(msg, event):
    if len(msg.Body) == 0:
        return
    if event == u"RECEIVED" or event == u"SENT" and msg.Sender.Handle != OWNER_HANDLE:
        if msg.ChatName == ROOM:
            for line in msg.Body.splitlines():
                namea = msg.Sender.FullName.split("(")[0]
                namea = msg.Sender.Handle if (len(namea) < 1 or len(namea) > 16) else namea
                bridge.say(CHANNEL, u"({name}) {msga}".format(name=munge(namea), msga=line))

class SkypeIRCBridge(SingleServerIRCBot):
    def __init__(self, skype, server = SERVER):
        SingleServerIRCBot.__init__(self, [(SERVER, PORT)], NICKNAME, NICKNAME)
        self.skype = skype
        self.channel = CHANNEL

    def on_nicknameinuse(self, c, e):
        c.nick(c.get_nickname() + "_")

    def on_welcome(self, c, e):
        c.join(self.channel)

    def say(self, channel, msg):
        self.connection.privmsg(channel, msg)

    def do_command(self, c, e):
        msg = " ".join(e.arguments)
        self.say(self.channel, msg.encode('utf-8'))

    def skype_handler(self, c, e):
        msg = "(IRC) " + " ".join(e.arguments)
        self.skype.Chat(ROOM).SendMessage(msg)

    on_pubnotice = do_command
    on_privnotice = do_command
    on_pubmsg = skype_handler
    on_privmsg = do_command

skype = Skype4Py.Skype()
skype.OnMessageStatus = skype_handler
skype.Attach()
chat = [a for a in skype.Chats if a.Name == ROOM][0]
bridge = SkypeIRCBridge(skype)
bridge.start()