#!/usr/bin/env python
import tweepy
import json
import random

with open(".twitter_config.json") as f:
  # a json file containing {"ckey": "", "csec": "", "utok": "", "usec": ""}
  config = json.load(f)

auth = tweepy.OAuthHandler(config["ckey"], config["csec"])
auth.set_access_token(config["utok"], config["usec"])
api = tweepy.API(auth)

with open("emoji.dat") as f:
  # generated using the other snippet below
  d = [i.encode('utf-8') for i in json.load(f)]

api.update_profile("Steven Smith " + random.choice(d))