<?php
$arr = array();
foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator('.', FilesystemIterator::SKIP_DOTS)) as $item => $file) {
  $arr[] = $item;
}
sort($arr);
?>
<html>
<head>
<style>
div.filelist {
  overflow-y: scroll;
  height: 90%;
}
</style>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script>
var audio = document.createElement('audio');

$(window).load(function() {
    audio.setAttribute('src', '');
    audio.setAttribute('controls', 'controls');
    audio.setAttribute('id', 'audio');
    $('body').prepend(audio);
    audio.load();
    audio.addEventListener("ended", function () {
        if (document.getElementById('autoplay').checked) {
            playRandom();
        }
    });
    if (window.location.hash != "" || window.location.hash != "#") {
        set_src(window.location.hash.substring(1));
    }
});

function playRandom() {
    try {
        var list = $('ul').find('li');
        set_src($(list[Math.floor(Math.random()*list.length)]).find('a')[0].innerHTML);
    } catch (err) {
        playRandom();
    }
}

function set_src(filename) {
    audio.setAttribute('src', filename);
    audio.load();
    audio.play();
    window.location.hash = filename;
    return false;
}
</script>
</head>
<body>
<a href="#" onclick="playRandom(); return false;">Random</a><form><input type="checkbox" name="autoplay" id="autoplay" checked>Autoplay
<div class="filelist">
<ul>
<?php
foreach($arr as $item) {
  if (mime_content_type($item) == "audio/mpeg") {
    $item = substr($item, 2); ?>
    <li><a href="#<?php echo $item; ?>" onClick="return set_src('<?php echo $item; ?>');"><?php echo $item; ?></a></li>
<?php } }
?>
</ul>
</div>
</body>
</html>
