#!/bin/bash
# hlstranscode "$URL"

cat >/tmp/cloud.conf <<EOFF
#!/bin/bash
apt-get update -qq
apt-get install ffmpeg -y -qq
curl https://rclone.org/install.sh | bash 2>/dev/null >/dev/null

export ID=\$(curl http://169.254.169.254/metadata/v1/id 2>/dev/null)
export URL="$1"

mkdir -p /root/.config/rclone /root/inp
cat > /root/.config/rclone/rclone.conf <<EOF
$(cat ~/.config/rclone/rclone.conf)
EOF

cd /root/inp
curl "\$URL" -O 2>/dev/null
export SUM=\$(sha1sum * | awk '{print \$1}')
cd /root

git clone https://github.com/vincentbernat/video2hls /root/video2hls 2>/dev/null
/root/video2hls/video2hls --output /root/out/\$SUM /root/inp/*
ffmpeg -i /root/inp/* /root/out/\$SUM/index.vtt 2>/dev/null
rclone copy /root/out/ b2:ads-share/hls/ --transfers=40

echo \$SUM
echo "ALLDONE (ctrl-c)"
curl -X DELETE -H "Authorization: Bearer $(grep access-token "/Users/alyssa/Library/Application Support/doctl/config.yaml" | awk '{print $2}')" https://api.digitalocean.com/v2/droplets/\$ID
EOFF
cat /tmp/cloud.conf
#read IP <<< $(set -x; doctl compute droplet create $(base32 -w0 <<<"$1" | sed 's/=/0/g') --region sgp1 --size s-16vcpu-64gb --image ubuntu-20-04-x64 --ssh-keys 28633873,28633866,29533274,29451733,29347920,30747235 --user-data-file /tmp/cloud.conf --wait --no-header --format PublicIPv4)
(set -x; doctl compute droplet create hlstranscode-$(date +%Y%m%d-%H%M%S) --region sgp1 --size s-16vcpu-64gb --image ubuntu-20-04-x64 --ssh-keys 28633873,28633866,29533274,29451733,29347920,30747235 --user-data-file /tmp/cloud.conf)
rm /tmp/cloud.conf
#until (ssh -o StrictHostKeyChecking=no root@$IP tail -f /var/log/cloud-init-output.log); do
#  sleep 1
#done