from datetime import datetime
from textwrap import wrap

hour = ["twelve", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven"]
letters = "ITLISASAMPMACQUARTERDCTWENTYFIVEXHALFSTENFTOPASTERUNINEONESIXTHREEFOURFIVETWOEIGHTELEVENSEVENTWELVETENSEOCLOCK" # 110 letters

def get_led_matrix():
    out = "0" * len(letters)
    time = get_time_in_words()
    for word in time.split():
        start = find_substr_in_str(word.upper(), letters)
        end = start + len(word)
        out = out[:start] + "1" * len(word) + out[end:]
    return out

def find_substr_in_str(needle, haystack):
    for c in range(0,len(haystack)):
        if haystack[c:c+len(needle)] == needle:
            return c

def get_time_in_words(time=None):
    if not time:
        time = datetime.now()
    h,m = hour[time.hour%12], time.minute
    if time.second > 30:
        m += 1
    m = round(m/5)*5
    if m == 0:
        return f"it is {h} oclock"
    elif m == 5:
        return f"five past {h}"
    elif m == 10:
        return f"ten past {h}"
    elif m == 15:
        return f"quarter past {h}"
    elif m == 20:
        return f"twenty past {h}"
    elif m == 25:
        return f"twentyfive past {h}"
    elif m == 30:
        return f"half past {h}"
    elif m == 35:
        return f"twentyfive to {h}"
    elif m == 40:
        return f"twenty to {h}"
    elif m == 45:
        return f"quarter to {h}"
    elif m == 50:
        return f"ten to {h}"
    elif m == 55:
        return f"five to {h}"

if __name__ == "__main__":
    print(datetime.now())
    print(get_time_in_words())
    print("\n".join(wrap(get_led_matrix(),11)))
    print("\n".join(wrap(letters,11)))