import os
import requests
import XML2Dict # The PyPI installer doesn't work; get this from http://blha303.com.au/XML2Dict.zip
from sys import argv

apikey = argv[1] # Get your API key from http://www.thetvdb.com/wiki/index.php?title=Programmers_API
ids = {"The.Daily.Show": "71256", "The.Colbert.Report": "79274", "Craig.Ferguson": "73387"}
eplookupurl = "http://thetvdb.com/api/GetEpisodeByAirDate.php?apikey=%s&seriesid=%s&airdate=%s"
srslookupurl = "http://thetvdb.com/data/series/%s/en.xml"
# I hate working with XML, so let's make them dicts.
xml = XML2Dict.encoder.XML2Dict()
continuing = False
# iterate over files in current directory
for filename in os.listdir('.'):
  # iterate over list of shows to process, above
  for k,v in ids.items():
    # If filename contains one of the keys from the list
    if k in filename:
      # Get the airdate from the filename
      airdate = "-".join(filename.split(".")[len(k.split(".")):len(k.split("."))+3])
      print "[%s] Processing %s" % (k, filename)
      # Get episode data from thetvdb
      data = xml.parse(requests.get(eplookupurl % (apikey, v, airdate)).text)
      # Get show data from thetvdb, to get the proper series name
      data["Data"]["Episode"]["SeriesName"] = xml.parse(requests.get(srslookupurl % v).text)["Data"]["Series"]["SeriesName"]
      out = "{SeriesName} s{SeasonNumber}e{EpisodeNumber}.".format(**data["Data"]["Episode"]) + filename.split(".")[-1]
      # Rename file
      os.rename(filename, out)
      print "[%s] Renamed to %s" % (k, out)
      # Continue for both for loops, because we've already identified the show.
      continuing = True
      continue
  if continuing:
    continuing = False
    continue
  print "Skipping " + filename