import libtorrent as lt
from os import listdir
import json

def sizeof_fmt(num):
    for x in ['bytes','KB','MB','GB']:
        if num < 1024.0 and num > -1024.0:
            return "%3.1f%s" % (num, x)
        num /= 1024.0
    return "%3.1f%s" % (num, 'TB')

x = 1
dirlist = listdir('.')

def main(dirlist):
    total = []
    x = 1
    try:
        with open('cache.json') as f:
            cache = json.loads(f.read())
    except:
        cache = {}
    try:
        for a in dirlist:
            if not a.split(".")[-1] == "torrent":
                continue
            if not a in cache:
                info = lt.torrent_info(lt.bdecode(open(a, 'rb').read()))
                tot = info.total_size()
                cache[a] = tot
            else:
                tot = cache[a]
            total.append(tot)
            print str(cache[a]) + " %s/%s" % (x, len(dirlist))
            x += 1
    finally:
        with open('cache.json', 'w') as f:
            f.write(json.dumps(cache))
    return total

if __name__ == "__main__":
    dirlist = listdir('.')
    total = main(dirlist)
    print sizeof_fmt(sum(total))