#!/bin/bash
domain="alyssasmith.id.au"
if [ -z "$1" ]; then
  region="syd"
else
  region="$1"
fi
if [ -z "$2" ]; then
  size="vc2-4c-8gb"
else
  size="$2"
fi
echo "please don't run this script without reading it first"
exit
if (vultr-cli regions availability $region | grep $size); then
  python -c "from datetime import datetime, timedelta; print('est time of completion: {} (9 minutes)'.format(datetime.now()+timedelta(minutes=9)))"
  read ID <<<$((set -x; vultr-cli instance create --label "${region}w" --host "$region.w.$domain" --firewall-group a4496c76-4a45-4051-a923-3d2d08159dcc --script-id 03c1ae6a-59f6-4190-a8a1-af9f1e23c1f0 --region "$region" --os 371 --plan "$size") | egrep '^ID\t' | awk '{print $2}')
  echo https://my.vultr.com/subs/vps/novnc/?id=$ID
  echo -n Waiting for IP
  until vultr-cli instance list | grep "${region}w" | awk '{print $2}' | grep -v "0.0.0.0" >/dev/null; do
    echo -n "."
    sleep 1;
  done
  read IP <<<$(vultr-cli instance list | grep "${region}w" | awk '{print $2}')
  read DOID <<<$(doctl compute domain records list $domain | grep $region.w | awk '{print $1}')
  if [ -z "$DOID" ]; then
    (set -x; doctl compute domain records create $domain --record-name $region.w --record-type A --record-data $IP)
  else
    (set -x; doctl compute domain records update $domain --record-id $DOID --record-name $region.w --record-type A --record-data $IP)
  fi
  echo Waiting for ssh
  until ssh -o StrictHostKeyChecking=no administrator@$IP; do
    sleep 1
  done
  if read -p "Delete instance?" a; then
    (set -x; vultr-cli instance delete $ID)
  fi
else
  echo "$size not available in $region"
fi