#!/usr/bin/env python3
import subprocess,gmusicapi,sys,mutagen,os
c = gmusicapi.Mobileclient()
c.login(os.environ["GMUSICAPI_EMAIL"], os.environ["GMUSICAPI_PASSWORD"], os.environ["GMUSICAPI_MACADDR"])

for track in c.get_album_info(sys.argv[1], include_tracks=True)["tracks"]:
    try:
        fn = "{trackNumber:0>2} {artist} - {title}.mp3".format(**track).replace("/", "-")
        print(fn)
        p = subprocess.run(["wget", c.get_stream_url(track["storeId"]), "-O", fn], stderr=subprocess.DEVNULL, stdout=subprocess.DEVNULL)
        f = mutagen.File(fn, easy=True)
        for x in ["title", "artist", "album"]:
            if track[x]:
                f[x] = track[x]
        f.save()
    except KeyError:
        print("Error on {artist} - {song}".format(**track))
        continue
    except IndexError:
        print("Error on {artist} - {song} index".format(**track))
        continue