# getsizefromurls.py
# Gets total size of files indicated by a list of urls
# Usage:
# getsizefromurls.py [input filename] [output filename]
# If parameters aren't provided, defaults to list.txt for input and <scriptfilename>output.txt for output
# Licensed under the MIT license because I couldn't find anything to do this using Google
# Outputs:

# File: live_user_moltov_1385511049.flv | Size: 167.6MB | Subtotal: 167.6MB
# File: live_user_moltov_1385512849.flv | Size: 172.6MB | Subtotal: 340.2MB
# File: live_user_moltov_1385514650.flv | Size: 182.1MB | Subtotal: 522.3MB
# File: live_user_moltov_1385516452.flv | Size: 181.8MB | Subtotal: 704.1MB
# File: live_user_moltov_1385518253.flv | Size: 8.6MB | Subtotal: 712.8MB

# to file, and prints:

# Total: 712.8MB

# in the terminal after those lines.

from urllib2 import urlopen
import sys
from os import sep

filename = ".".join(sys.argv[0].split(sep)[-1].split(".")[:-1])


def sizeof_fmt(num):
    for x in ['bytes','KB','MB','GB','TB','PB','EB','ZB']:
        if num < 1024.0 and num > -1024.0:
            return "%3.1f%s" % (num, x)
        num /= 1024.0
    return "%3.1f%s" % (num, 'YB')


def main(inp='list.txt', out=filename+'output.txt'):
    bytes = 0
    with open(inp) as f:
        urls = [url.strip() for url in f.readlines()]
    with open(out,'w') as output:
        for x in urls:
            a = urlopen(x)
            bytes = bytes + int(a.headers["Content-Length"])
            name = x.split("/")[-1]
            output.write("File: %s | Size: %s | Subtotal: %s\n" % (name, sizeof_fmt(int(a.headers["Content-Length"])), sizeof_fmt(bytes)))
            print "File: %s | Size: %s | Subtotal: %s" % (name, sizeof_fmt(int(a.headers["Content-Length"])), sizeof_fmt(bytes))
        print "Total: " + sizeof_fmt(bytes)
    return 0


if __name__ == "__main__":
    if len(sys.argv) > 1:
        if len(sys.argv) >= 3:
            sys.exit(main(inp=sys.argv[1], out=sys.argv[2]))
        elif len(sys.argv) >= 2:
            sys.exit(main(inp=sys.argv[1]))
    else:
        sys.exit(main())