from urllib2 import urlopen
import sys
from os import sep

filename = ".".join(sys.argv[0].split(sep)[-1].split(".")[:-1])


def sizeof_fmt(num):
    for x in ['bytes','KB','MB','GB','TB','PB','EB','ZB']:
        if num < 1024.0 and num > -1024.0:
            return "%3.1f%s" % (num, x)
        num /= 1024.0
    return "%3.1f%s" % (num, 'YB')


def main(inp='list.txt', out=filename+'output.txt'):
    bytes = 0
    with open(inp) as f:
        urls = [url.strip() for url in f.readlines()]
    with open(out,'w') as output:
        for x in urls:
            a = urlopen(x)
            bytes = bytes + int(a.headers["Content-Length"])
            name = x.split("/")[-1]
            out = "File: {0:35} | Size: {1:7} | Subtotal: {2}\n".format(name[:32]+"..." if len(name)>35 else name, sizeof_fmt(int(a.headers["Content-Length"])), sizeof_fmt(bytes))
            output.write(out)
            print out.strip()
        print "Total: " + sizeof_fmt(bytes)
    return 0


if __name__ == "__main__":
    if len(sys.argv) > 1:
        if len(sys.argv) >= 3:
            sys.exit(main(inp=sys.argv[1], out=sys.argv[2]))
        elif len(sys.argv) >= 2:
            sys.exit(main(inp=sys.argv[1]))
    else:
        sys.exit(main())
