#!/usr/bin/env python2
from bs4 import BeautifulSoup as Soup
import requests
from collections import namedtuple
from datetime import datetime, timedelta

Song = namedtuple('Song', ['title', 'artist', 'position', 'spotify', 'vevo', 'rdio'])

def billboard(date):
    soup = Soup(requests.get("http://www.billboard.com/charts/hot-100/%s" % date).text)
    songs = soup.findAll('article', {'class': 'chart-row'})
    for item in songs:
        title = item.find('h2').text.strip()
        artist = item.find('h3').text.strip()
        position = item.find('span', {'class': 'this-week'}).text.strip()
        _ = item.find('a', {'class': 'spotify'})
        spotify = _["href"].split("uri=")[1] if _ else None
        _ = item.find('a', {'title': 'Vevo'})
        vevo = _["href"].split("video=")[1] if _ else None
        _ = item.find('a', {'class': 'rdio'})
        rdio = _['href'] if _ else None
        yield Song(title, artist, position, spotify, vevo, rdio)

if __name__ == "__main__":
    for song in billboard('2015-06-06'):
        print song