# a function to listen for the current jackbox room id being received
# requirements: pyshark python module, tshark library or wireshark
# sometimes the code gets cut off between packets. need to restart the current game if no code is found; this happens 10% of the time
def get_jackbox_room_code(packet_count=None):
    """ blocks until room code is found or packet_count is reached
    >>> get_jackbox_room_code()
    'CTLE' """
    def get_outgoing_ip():
        import socket
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(("8.8.8.8", 80))
        return s.getsockname()[0]
    roomcode = ""
    c = pyshark.LiveCapture(display_filter="websocket")
    for packet in c.sniff_continuously(packet_count):
        if packet.ip.addr[0] != get_outgoing_ip(): 
            try:
                d = packet.websocket.payload_unknown.replace(":", "").decode('hex')
                if '"roomId":"' in d:
                    roomcode = d.split('"roomId":"')[1].split('"')[0]
                elif '","blob":{"state":"Lobby_WaitingForMore"}}' in d:
                    roomcode = d.split('","blob":{"state":"Lobby_WaitingForMore"}}')[0].split('"')[1]
            except (AttributeError, IndexError):
                pass
            try:
                d = packet.data.tcp_reassembled_data.replace(":", "").decode('hex')
                if '"roomId":"' in d:
                    roomcode = d.split('"roomId":"')[1].split('"')[0]
                elif '","blob":{"state":"Lobby_WaitingForMore"}}' in d:
                    roomcode = d.split('","blob":{"state":"Lobby_WaitingForMore"}}')[0].split('"')[1]
            except (AttributeError, IndexError):
                pass
        if roomcode and len(roomcode) == 4:
            break
    return roomcode